Relying on system variables specific to users or environments may introduce inconsistent behavior across different sessions.

# What Does This Check Look For?
This check identifies ABAP statements where code accesses environment-specific information, such as system variables (e.g., `SY-UNAME` or `SY-SYSID`), return values from methods of the `CL_ABAP_CONTEXT_INFO` class, or the XCO SY library (i.e., `XCO_CP=>SY->user()`).

# Why is This a Problem?
Accessing system variables that hold user or environment-specific data can lead to unpredictable behavior because the code might operate differently based on who is logged in or the system environment in use.
This can complicate testing and result in bugs that are difficult to reproduce and resolve.
It is important to decouple application logic from system-specific details to maintain consistency and reliability.

# How Can I Resolve This?
Consider using application configuration tables or parameters that provide required information uniformly to all users and environments.
This approach centralizes the control of these variables and ensures that the application's behavior is consistent regardless of the session or user details.

# Examples

## Non-Compliant

```abap
DATA(bank_interface) TYPE REF TO zcl_bank_interface.
CREATE OBJECT bank_interface.
bank_interface->withdraw_100_dollar( iv_account_name = sy-uname ).
```

## Compliant

```abap
DATA(account_name) TYPE string.
SELECT SINGLE account INTO account_name FROM accounts WHERE account_id = '1234'.

DATA(bank_interface) TYPE REF TO zcl_bank_interface.
CREATE OBJECT bank_interface.
bank_interface->withdraw_100_dollar( iv_account_name = account_name ).
```
# Where Can I Learn More?
- [ABAP Programming Guidelines - ABAP System Fields](https://help.sap.com/doc/abapdocu_752_index_htm/7.52/en-US/abensystem_fields.htm)