# Description
Find overlapping classic exceptions

# Extended Information
When debugging its typically good to know exactly which exception is caught

# Examples
**Bad example**
```abap
CALL FUNCTION 'SOMETHING'
  EXCEPTIONS
    system_failure        = 1 MESSAGE lv_message
    communication_failure = 1 MESSAGE lv_message
    resource_failure      = 1
    OTHERS                = 1.
```

**Good example**
```abap
CALL FUNCTION 'SOMETHING'
  EXCEPTIONS
    system_failure        = 1 MESSAGE lv_message
    communication_failure = 2 MESSAGE lv_message
    resource_failure      = 3
    OTHERS                = 4.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/classic_exceptions_overlap) <br>
