
**DON'T** check for `null` in custom `==` operators.

As `null` is a special value, no instance of any class (other than `Null`) can
be equivalent to it.  Thus, it is redundant to check whether the other instance
is `null`.

**BAD:**
```dart
class Person {
  final String? name;

  @override
  operator ==(Object? other) =>
      other != null && other is Person && name == other.name;
}
```

**GOOD:**
```dart
class Person {
  final String? name;

  @override
  operator ==(Object? other) => other is Person && name == other.name;
}
```
