The @Attribute decorator is used to obtain a single value for an attribute. This is a much less common use-case than getting a stream of values (using @Input), so often the @Attribute decorator is mistakenly used when @Input was what was intended. This rule disallows usage of @Attribute decorator altogether in order to prevent these mistakes.

- Type: problem

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
class Test {
  constructor(@Attribute() foo: string) {}
              ~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
class Test {
  constructor(
    @Inject(TOKEN) token: string,
    randomNumber: number,
    @Attribute() foo: string,
    ~~~~~~~~~~~~
    @Attribute('baz') bar: string
    ~~~~~~~~~~~~~~~~~
  ) {}
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {
  foo() {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test {
  constructor() {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test {
  constructor(@Optional() foo: string, @Optional() bar: string, baz: number) {}
}
```

</details>
