Disallows explicit calls to lifecycle methods

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  test(): void {
    this.ngAfterContentChecked();
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  test(): void {
    this.ngAfterContentInit();
    ~~~~~~~~~~~~~~~~~~~~~~~~~
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  test(): void {
    this.ngAfterViewChecked();
    ~~~~~~~~~~~~~~~~~~~~~~~~~
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test {
  test(): void {
    this.ngAfterViewInit();
    ~~~~~~~~~~~~~~~~~~~~~~
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe()
class Test {
  test(): void {
    this.ngDoBootstrap();
    ~~~~~~~~~~~~~~~~~~~~
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  test(): void {
    this.ngDoCheck();
    ~~~~~~~~~~~~~~~~
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  test(): void {
    this.ngOnChanges();
    ~~~~~~~~~~~~~~~~~~
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  test(): void {
    this.ngOnDestroy();
    ~~~~~~~~~~~~~~~~~~
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test {
  test(): void {
    this.ngOnInit();
    ~~~~~~~~~~~~~~~
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({ template: '' })
class Test extends ParentComponent {
  test(): void {
    super.ngOnChanges();
    ~~~~~~~~~~~~~~~~~~~
  }
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngAfterContentChecked(): void {
    super.ngAfterContentChecked();
  }
}

@Directive()
class Test {
  test(): void {
    this.ngAfterContentChecked1();
    this.angAfterContentInit();
    this.ngAfterViewChecked2();
    this.ngAfterViewInit3();
    this.ngOnChange$();
    this.ngOnDestroyx();
    this.ngOnInitialize();
    this.ngDoChecking();
    ngOnInit();
  }
}

@MyDecorator()
class Test {
  test(): void {
    ngDoCheck();
  }
}

ngOnDestroy();
```

</details>
