Prefer to declare `@Output` as `readonly` since they are not supposed to be reassigned

- Type: suggestion

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
class Test {
  @Output() testEmitter = new EventEmitter<string>();
            ~~~~~~~~~~~
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {
  testEmitter = new EventEmitter<string>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test {
  @Output() readonly testEmitter = new EventEmitter<string>();
}
```

</details>
