<h2>Why is this an issue?</h2>
<p>Overriding a method just to call the same method from the base class without performing any other actions is useless and misleading. The only time
this is justified is in <code>sealed</code> overriding methods, where the effect is to lock in the parent class behavior. This rule ignores overrides
of <code>Equals</code> and <code>GetHashCode</code>.</p>
<p>NOTE: In some cases it might be dangerous to add or remove empty overrides, as they might be breaking changes.</p>
<h3>Noncompliant code example</h3>
<pre>
public override void Method() // Noncompliant
{
  base.Method();
}
</pre>
<h3>Compliant solution</h3>
<pre>
public override void Method()
{
  //do something else
}
</pre>
<h3>Exceptions</h3>
<p>If there is an attribute in any level of the overriding chain, then the overridden member is ignored.</p>
<pre>
public class Base
{
  [Required]
  public virtual string Name { get; set; }
}

public class Derived : Base
{
  public override string Name
  {
    get
    {
      return base.Name;
    }
    set
    {
      base.Name = value;
    }
  }
}
</pre>
<p>If there is a documentation comment on the overriding method, it will be ignored:</p>
<pre>
public class Foo : Bar
{
    /// &lt;summary&gt;
    /// Keep this method for backwards compatibility.
    /// &lt;/summary&gt;
    public override void DoSomething()
    {
        base.DoSomething();
    }
}
</pre>

