<p>Within a <a href="https://messagetemplates.org/">message template</a> each named placeholder should be in PascalCase.</p>
<h2>Why is this an issue?</h2>
<p>Using consistent naming conventions is important for the readability and maintainability of code. In the case of message templates, using
PascalCase for named placeholders ensures consistency with structured logging conventions, where each named placeholder is used as a property name in
the structured data.</p>
<p>The rule covers the following logging frameworks:</p>
<ul>
  <li> Nuget package - <a href="https://www.nuget.org/packages/Microsoft.Extensions.Logging">Microsoft.Extensions.Logging</a> </li>
  <li> Nuget package - <a href="https://www.nuget.org/packages/Serilog">Serilog</a> </li>
  <li> Nuget package - <a href="https://www.nuget.org/packages/NLog">Nlog</a> </li>
</ul>
<h2>How to fix it</h2>
<p>Use PascalCase for named placeholders.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
logger.LogDebug("User {firstName} logged in", firstName); // Noncompliant
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
logger.LogDebug("User {FirstName} logged in", firstName); // Compliant
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1727">CA1727: Use PascalCase for
  named placeholders</a> </li>
  <li> Serilog Analyzer - <a
  href="https://github.com/Suchiman/SerilogAnalyzer/blob/master/README.md#serilog006-pascal-cased-property-verifier">Serilog006: Pascal Cased Property
  Verifier</a> </li>
</ul>

