﻿## SA1017

<table>
<tr>
  <td>TypeName</td>
  <td>SA1017ClosingAttributeBracketsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1017</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A closing attribute bracket within a C# element is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around a closing attribute bracket is not correct.

A closing attribute bracket should never be preceded by whitespace, unless the bracket is the first character on the line.

## How to fix violations

To fix a violation of this rule, ensure that there is no whitespace before the closing attribute bracket.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1017:ClosingAttributeBracketsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1017 // ClosingAttributeBracketsMustBeSpacedCorrectly
#pragma warning restore SA1017 // ClosingAttributeBracketsMustBeSpacedCorrectly
```
