﻿## SA1020

<table>
<tr>
  <td>TypeName</td>
  <td>SA1020IncrementDecrementSymbolsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1020</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

An increment or decrement symbol within a C# element is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around an increment or decrement symbol is not correct.

There should be no whitespace between the increment or decrement symbol and the item that is being incremented or decremented.

## How to fix violations

To fix a violation of this rule, ensure that there is no whitespace between the increment or decrement symbol and the item that is being incremented or decremented.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1020:IncrementDecrementSymbolsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1020 // IncrementDecrementSymbolsMustBeSpacedCorrectly
#pragma warning restore SA1020 // IncrementDecrementSymbolsMustBeSpacedCorrectly
```
