## SA1129

<table>
<tr>
  <td>TypeName</td>
  <td>SA1129DoNotUseDefaultValueTypeConstructor</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1129</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

A value type was constructed using the syntax `new T()`.

## Rule description

A violation of this rule occurs when a value type `T` is constructed using the syntax `new T()`. To create a default
instance of a value type, use the equivalent syntax `default(T)` instead.

For example, the following code would produce a violation of this rule:

```csharp
ImmutableArray<int> array = new ImmutableArray<int>();
```

While the above appears to create a new immutable array which is ready to use, in reality the variable `array` was
assigned a default instance of `ImmutableArray<int>`, and almost any attempt to use the variable will result in a
`NullReferenceException`. To avoid confusion with the behavior of reference types, default instances of value types
should always be created using the syntax `default(T)` instead.

> :memo: This proposal only refers to the distinction between `default(T)` and `new T()`. Other default values,
> including `CancellationToken.None`, `0`, `0.0f`, `IntPtr.Zero`, and `RegexOptions.None`, would *not* produce a
> warning.

## How to fix violations

To fix a violation of this rule, replace the syntax `new T()` with the equivalent syntax `default(T)`.

## How to suppress violations

```csharp
#pragma warning disable SA1129 // Do not use default value type constructor
IntPtr zero = new IntPtr();
#pragma warning restore SA1129 // Do not use default value type constructor
```
