﻿## SA1210

<table>
<tr>
  <td>TypeName</td>
  <td>SA1210UsingDirectivesMustBeOrderedAlphabeticallyByNamespace</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1210</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

The using directives within a C# code file are not sorted alphabetically by namespace.

## Rule description

A violation of this rule occurs when the using directives are not sorted alphabetically by namespace. Sorting the using directives alphabetically makes the code cleaner and easier to read, and can help make it easier to identify the namespaces that are being used by the code. The System namespaces are an exception to this rule and will always precede all other namespaces. See SA1208 for more details.

## How to fix violations

To fix an instance of this violation, order the using directives alphabetically by namespace with all the System namespace entries first.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1210:UsingDirectivesMustBeOrderedAlphabeticallyByNamespace", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1210 // UsingDirectivesMustBeOrderedAlphabeticallyByNamespace
#pragma warning restore SA1210 // UsingDirectivesMustBeOrderedAlphabeticallyByNamespace
```
