﻿## SA1212

<table>
<tr>
  <td>TypeName</td>
  <td>SA1212PropertyAccessorsMustFollowOrder</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1212</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

A get accessor appears after a set or init accessor within a property or indexer.

## Rule description

A violation of this rule occurs when a get accessor is placed after a set or init accessor within a property or indexer. To comply with this rule, the get accessor should appear first.

For example, the following code would raise an instance of this violation:

```csharp
public string Name
{ 
    set { this.name = value; }
    get { return this.name; }
}
```

The code below would not raise this violation:

```csharp
public string Name
{ 
    get { return this.name; }
    set { this.name = value; }
}
```

## How to fix violations

To fix an instance of this violation, place the get accessor before the set accessor.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1212:PropertyAccessorsMustFollowOrder", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1212 // PropertyAccessorsMustFollowOrder
#pragma warning restore SA1212 // PropertyAccessorsMustFollowOrder
```
