﻿## SA1215

<table>
<tr>
  <td>TypeName</td>
  <td>SA1215InstanceReadonlyElementsMustAppearBeforeInstanceNonReadonlyElements</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1215</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

An instance readonly element is positioned beneath an instance non-readonly element of the same type.

## Rule description

A violation of this rule occurs when an instance readonly element is positioned beneath an instance non-readonly element of the same type.

## How to fix violations

To fix an instance of this violation, place all instance readonly elements above all instance non-readonly elements of the same type.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1215:InstanceReadonlyElementsMustAppearBeforeInstanceNonReadonlyElements", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1215 // InstanceReadonlyElementsMustAppearBeforeInstanceNonReadonlyElements
#pragma warning restore SA1215 // InstanceReadonlyElementsMustAppearBeforeInstanceNonReadonlyElements
```
