# SA1217

<table>
<tr>
  <td>TypeName</td>
  <td>SA1217UsingStaticDirectivesMustBeOrderedAlphabetically</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1217</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

The `using static` directives within a C# code file are not sorted alphabetically by full type name.

## Rule description

A violation of this rule occurs when the `using static` directives are not sorted alphabetically by full type name. Sorting the `using static` directives alphabetically makes the code cleaner and easier to read.

## How to fix violations

To fix an instance of this violation, order the `using static` directives alphabetically by full type name.

## How to suppress violations

```csharp
#pragma warning disable SA1217 // Using static directives should be ordered alphabetically
using static System.Math;
#pragma warning restore SA1217 // Using static directives should be ordered alphabetically
```
