﻿## SA1310

<table>
<tr>
  <td>TypeName</td>
  <td>SA1310FieldNamesMustNotContainUnderscore</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1310</td>
</tr>
<tr>
  <td>Category</td>
  <td>Naming Rules</td>
</tr>
</table>

## Cause

A field name in C# contains an underscore.

## Rule description

A violation of this rule occurs when a field name contains an underscore. Fields and variables should be named using descriptive, readable wording which describes the function of the field or variable. Typically, these names will be written using camel case, and should not use underscores. For example, use *customerPostCode* rather than *customer_post_code*.

If the field or variable name is intended to match the name of an item associated with Win32 or COM, and thus needs to include underscores, place the field or variable within a special *NativeMethods* class. A NativeMethods class is any class which contains a name ending in NativeMethods, and is intended as a placeholder for Win32 or COM wrappers. StyleCop will ignore this violation if the item is placed within a NativeMethods class.

## How to fix violations

To fix a violation of this rule, remove the underscore from the name of the field, or place the item within a NativeMethods class if appropriate.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.NamingRules", "SA1310:FieldNamesMustNotContainUnderscore", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1310 // FieldNamesMustNotContainUnderscore
#pragma warning restore SA1310 // FieldNamesMustNotContainUnderscore
```
