﻿## SA1512

<table>
<tr>
  <td>TypeName</td>
  <td>SA1512SingleLineCommentsMustNotBeFollowedByBlankLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1512</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

A single-line comment within C# code is followed by a blank line.

## Rule description

To improve the readability of the code, StyleCop requires blank lines in certain situations, and prohibits blank lines in other situations. This results in a consistent visual pattern across the code, which can improve recognition and readability of unfamiliar code.

A violation of this rule occurs when a single-line comment is followed by a blank line. For example:

```csharp
public bool Enabled
{
    get 
    {
        // Return the value of the 'enabled' field.

        return this.enabled;
    }
}
```

The code above would generate an instance of this violation, since the single-line comment is followed by a blank line.

It is allowed to place a blank line in between two blocks of single-line comments. For example:

```csharp
public bool Enabled
{
    get 
    {
        // This is a sample comment which doesn't really say anything.
        // This is another part of the comment.

        // There is a blank line above this comment but that is ok.
        return this.enabled;  
    }
}
```

If the comment is being used to comment out a line of code, place four forward slashes at the beginning of the comment, rather than two. This will cause StyleCop to ignore this violation. For example:

```csharp
public bool Enabled
{
    get 
    {
        ////return false;

        return this.enabled;  
    }
}
```

## How to fix violations

To fix a violation of this rule, remove the blank line following the single-line comment.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1512:SingleLineCommentsMustNotBeFollowedByBlankLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1512 // SingleLineCommentsMustNotBeFollowedByBlankLine
#pragma warning restore SA1512 // SingleLineCommentsMustNotBeFollowedByBlankLine
```
