﻿## SA1606

<table>
<tr>
  <td>TypeName</td>
  <td>SA1606ElementDocumentationMustHaveSummaryText</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1606</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The `<summary>` tag within the documentation header for a C# code element is empty.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when the documentation header for an element contains an empty `<summary>` tag which does not contain a description of the element.

## How to fix violations

To fix a violation of this rule, fill-in the `<summary>` tag with a description of the code element.

Example:

The following example shows a method which contains an empty `<summary>` tag.

```csharp
/// <summary>  </summary>
/// <param name="customerId">The ID of the customer to find.</param>
/// <returns>The customer, or null if the customer could not be
/// found.</returns>
public Customer FindCustomer(int customerId)
{
    // ... finds the customer ...
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1606:ElementDocumentationMustHaveSummaryText", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1606 // ElementDocumentationMustHaveSummaryText
#pragma warning restore SA1606 // ElementDocumentationMustHaveSummaryText
```
