﻿## SA1608

<table>
<tr>
  <td>TypeName</td>
  <td>SA1608ElementDocumentationMustNotHaveDefaultSummary</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1608</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The `<summary>` tag within an element's Xml header documentation contains the default text generated by Visual Studio during the creation of the element.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

Visual Studio provides helper functionality for adding new elements such as classes to a project. Visual Studio will create a default documentation header for the new class and fill in this header with default documentation text.

A violation of this rule occurs when the `<summary>` tag for a code element still contains the default documentation text generated by Visual Studio.

## How to fix violations

To fix a violation of this rule, replace the default documentation text with new text describing the contents of the code element.

The following example shows a class which contains the default summary text generated by Visual Studio.

```csharp
/// <summary>
/// Summary description for the Example class.
/// </summary>
public class Example
{
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1608:ElementDocumentationMustNotHaveDefaultSummary", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1608 // ElementDocumentationMustNotHaveDefaultSummary
#pragma warning restore SA1608 // ElementDocumentationMustNotHaveDefaultSummary
```
