﻿## SA1612

<table>
<tr>
  <td>TypeName</td>
  <td>SA1612ElementParameterDocumentationMustMatchElementParameters</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1612</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The documentation describing the parameters to a C# method, constructor, delegate or indexer element does not match the actual parameters on the element.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs if the documentation for an element's parameters does not match the actual parameters on the element, or if the parameter documentation is not listed in the same order as the element's parameters.

## How to fix violations

To fix a violation of this rule, correct the parameter documentation so that the `<param>` tags in the documentation appear in the same order as the element's parameters, and so that there is one `<param>` tag for each parameter on the element.

The following example shows a method with a valid documentation header:

```csharp
/// <summary>
/// Joins a first name and a last name together into a single string.
/// </summary>
/// <param name="firstName">The first name to join.</param>
/// <param name="lastName">The last name to join.</param>
/// <returns>The joined names.</returns>
public string JoinNames(string firstName, string lastName)
{
    return firstName + " " + lastName;
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1612:ElementParameterDocumentationMustMatchElementParameters", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1612 // ElementParameterDocumentationMustMatchElementParameters
#pragma warning restore SA1612 // ElementParameterDocumentationMustMatchElementParameters
```
