﻿## SA1644

<table>
<tr>
  <td>TypeName</td>
  <td>SA1644DocumentationHeadersMustNotContainBlankLines</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1644</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

A section within the Xml documentation header for a C# element contains blank lines.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when the documentation header contains one or more blank lines within a section of documentation. For example:

```csharp
/// <summary>
/// Joins a first name and a last name together into a single string.
///
/// Uses a simple form of string concatenation.
/// </summary>
/// <param name="firstName">The first name to join.</param>
/// <param name="lastName">The last name to join.</param>
/// <returns>The joined names.</returns>
public string JoinNames(string firstName, string lastName)
{
    return firstName + " " + lastName;
}
```

Rather than inserting blank lines into the documentation, use the `<para>` tag to denote paragraphs. For example:

```csharp
/// <summary>
/// <para>
/// Joins a first name and a last name together into a single string.
/// </para><para>
/// Uses a simple form of string concatenation.
/// </para>
/// </summary>
/// <param name="firstName">The first name to join.</param>
/// <param name="lastName">The last name to join.</param>
/// <returns>The joined names.</returns>
public string JoinNames(string firstName, string lastName)
{
    return firstName + " " + lastName;
}
```

## How to fix violations

To fix a violation of this rule, remove the blank lines from the documentation header, and optionally replace them with `<para/>` tags.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1644:DocumentationHeadersMustNotContainBlankLines", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1644 // DocumentationHeadersMustNotContainBlankLines
#pragma warning restore SA1644 // DocumentationHeadersMustNotContainBlankLines
```
