<h2>Why is this an issue?</h2>
<p>A naming convention in software development is a set of guidelines for naming code elements like variables, functions, and classes.</p>
<p>The goal of a naming convention is to make the code more readable and understandable, which makes it easier to maintain and debug. It also ensures
consistency in the code, especially when multiple developers are working on the same project.</p>
<p>This rule checks that field names match a provided regular expression.</p>
<p>Using the regular expression <code>^[a-z][a-zA-Z0-9]*$</code>, the noncompliant code below:</p>

```java
class MyClass {
   private int my_field;
}
```
<p>Should be replaced with:</p>

```java
class MyClass {
   private int myField;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Oracle - <a href="https://www.oracle.com/java/technologies/javase/codeconventions-namingconventions.html">Java SE Naming Conventions</a> </li>
  <li> Geeksforgeeks - <a href="https://www.geeksforgeeks.org/java-naming-conventions/">Java Naming Conventions</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Naming_convention_(programming)">Naming Convention (programming)</a> </li>
</ul>