<h2>Why is this an issue?</h2>
<p>Non-abstract classes and enums with non-<code>static</code>, <code>private</code> members should explicitly initialize those members, either in a
constructor or with a default value.</p>
<h3>Noncompliant code example</h3>

```java
class A { // Noncompliant
  private int field;
}
```
<h3>Compliant solution</h3>

```java
class A {
  private int field;

  A(int field) {
    this.field = field;
  }
}
```
<h3>Exceptions</h3>
<ul>
  <li> Class implementing a Builder Pattern (name ending with "Builder"). </li>
  <li> <a href="https://docs.oracle.com/javaee/7/tutorial/index.html">Java EE</a> class annotated with:
    <ul>
      <li> <a href="https://docs.oracle.com/javaee/7/api/javax/annotation/ManagedBean.html">ManagedBean</a> </li>
      <li> <a href="https://docs.oracle.com/javaee/7/api/javax/ejb/MessageDriven.html">MessageDriven</a> </li>
      <li> <a href="https://docs.oracle.com/javaee/7/api/javax/ejb/Singleton.html">Singleton</a> </li>
      <li> <a href="https://docs.oracle.com/javaee/7/api/javax/ejb/Stateful.html">Stateful</a> </li>
      <li> <a href="https://docs.oracle.com/javaee/7/api/javax/ejb/Stateless.html">Stateless</a> </li>
      <li> <a href="https://docs.oracle.com/javaee/7/api/javax/jws/WebService.html">WebService</a> </li>
      <li> <a href="https://docs.oracle.com/javaee/7/api/javax/servlet/annotation/WebFilter.html">WebFilter</a> </li>
      <li> <a href="https://docs.oracle.com/javaee/7/api/javax/servlet/annotation/WebServlet.html">WebServlet</a> </li>
    </ul>  </li>
  <li> Class and field annotated with:
    <ul>
      <li> <a href="https://codehaus-plexus.github.io/plexus-containers/plexus-component-annotations/index.html">Plexus Component Annotations</a>
      </li>
      <li> <a href="https://maven.apache.org/developers/mojo-api-specification.html">Maven Mojo</a> </li>
    </ul>  </li>
  <li> Field annotated with:
    <ul>
      <li> <a href="https://docs.oracle.com/javaee/7/api/javax/annotation/Resource.html">Resource</a> </li>
      <li> <a href="https://docs.oracle.com/javaee/7/api/javax/ejb/EJB.html">EJB</a> </li>
      <li> <a href="https://docs.oracle.com/javaee/7/api/javax/inject/Inject.html">Inject</a> </li>
      <li> <a
      href="https://docs.spring.io/spring-framework/docs/current/javadoc-api/org/springframework/beans/factory/annotation/Autowired.html">Autowired</a> </li>
    </ul>  </li>
  <li> Class annotated with:
    <ul>
      <li> <a href="https://www.javadoc.io/doc/org.projectlombok/lombok/latest/lombok/Builder.html">Lombok Builder</a> </li>
    </ul>  </li>
</ul>