<p>This rule raises an issue when a collection implementation class from <code>java.util.*</code> is used:</p>
<ul>
  <li> as a return type of a <code>public</code> method. </li>
  <li> as an argument type of a <code>public</code> method. </li>
  <li> as the type of a <code>public</code> field. </li>
</ul>
<h2>Why is this an issue?</h2>
<p>The Java Collections API offers a well-structured hierarchy of interfaces designed to hide collection implementation details. For the various
collection data structures like lists, sets, and maps, specific interfaces (<code>java.util.List</code>, <code>java.util.Set</code>,
<code>java.util.Map</code>) cover the essential features.</p>
<p>When passing collections as method parameters, return values, or when exposing fields, it is generally recommended to use these interfaces instead
of the implementing classes. The implementing classes, such as <code>java.util.LinkedList</code>, <code>java.util.ArrayList</code>, and
<code>java.util.HasMap</code>, should only be used for collection instantiation. They provide finer control over the performance characteristics of
those structures, and developers choose them depending on their use case.</p>
<p>For example, if fast random element access is essential, <code>java.util.ArrayList</code> should be instantiated. If inserting elements at a random
position into a list is crucial, a <code>java.util.LinkedList</code> should be preferred. However, this is an implementation detail your API should
not expose.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public class Employees {
  public final HashSet<Employee> employees   // Noncompliant, field type should be "Set"
    = new HashSet<Employee>();

  public HashSet<Employee> getEmployees() {  // Noncompliant, return type should be "Set"
    return employees;
  }
}
```
<h4>Compliant solution</h4>

```java
public class Employees {
  public final Set<Employee> employees       // Compliant
    = new HashSet<Employee>();

  public Set<Employee> getEmployees() {      // Compliant
    return employees;
  }
}
```