<h2>Why is this an issue?</h2>
<p>Dead stores refer to assignments made to local variables that are subsequently never used or immediately overwritten. Such assignments are
unnecessary and don’t contribute to the functionality or clarity of the code. They may even negatively impact performance. Removing them enhances code
cleanliness and readability. Even if the unnecessary operations do not do any harm in terms of the program’s correctness, they are - at best - a waste
of computing resources.</p>
<h3>Exceptions</h3>
<p>This rule ignores initializations to <code>-1</code>, <code>0</code>, <code>1</code>, <code>null</code>, <code>true</code>, <code>false</code> and
<code>""</code>.</p>
<h2>How to fix it</h2>
<p>Remove the unnecesarry assignment, then test the code to make sure that the right-hand side of a given assignment had no side effects (e.g. a
method that writes certain data to a file and returns the number of written bytes).</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
int foo(int y) {
  int x = 100; // Noncompliant: dead store
  x = 150;     // Noncompliant: dead store
  x = 200;
  return x + y;
}
```
<h4>Compliant solution</h4>

```java
int foo(int y) {
  int x = 200; // Compliant: no unnecessary assignment
  return x + y;
}
```
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/563">CWE-563 - Assignment to Variable without Use ('Unused Variable')</a> </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> java:S2583 - Conditionally executed code should be reachable </li>
  <li> java:S2589 - Boolean expressions should not be gratuitous </li>
  <li> java:S3516 - Methods returns should not be invariant </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S3626'>java:S3626</a> - Jump statements should not be redundant </li>
</ul>