<h2>Why is this an issue?</h2>
<p>There’s no reason for a <code>main</code> method to <code>throw</code> anything. After all, what’s going to catch it?</p>
<p>Instead, the method should itself gracefully handle any exceptions that may bubble up to it, attach as much contextual information as possible, and
perform whatever logging or user communication is necessary, and <code>exit</code> with a non-zero (i.e. non-success) exit code if necessary.</p>
<h3>Noncompliant code example</h3>

```java
public static void main(String args[]) throws Exception { // Noncompliant
  doSomething();
}
```
<h3>Compliant solution</h3>

```java
public static void main(String args[]) {
 try {
    doSomething();
  } catch (Throwable t) {
    log.error(t);
    System.exit(1);  // Default exit code, 0, indicates success. Non-zero value means failure.
  }
}
```