<h2>Why is this an issue?</h2>
<p>Serialization is a platform-independent mechanism for writing the state of an object into a byte-stream. For serializing the object, we call the
<code>writeObject()</code> method of <code>java.io.ObjectOutputStream</code> class. Only classes that implement <code>Serializable</code> or extend a
class that does it can successfully be serialized (or de-serialized).</p>
<p>Attempting to write a class with the <code>writeObject</code> method of the <code>ObjectOutputStream</code> class that does not implement
<code>Serializable</code> or extends a class that implements it, will throw an <code>IOException</code>.</p>
<h2>How to fix it</h2>
<p>The object class passed as an argument to the <code>writeObject</code> must implement <code>Serializable</code>.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public class Vegetable {
  // ...
}

public class Menu {
  public void meal(ObjectOutputStream oos) throws IOException {
    Vegetable veg = new Vegetable();
    oos.writeObject(veg);  // Noncompliant
  }
}
```
<h4>Compliant solution</h4>

```java
public class Vegetable implements Serializable {
  // ...
}

public class Menu {
  public void meal(ObjectOutputStream oos) throws IOException {
    Vegetable veg = new Vegetable();
    oos.writeObject(veg);
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/en/java/javase/20/docs/api/java.base/java/io/Serializable.html">Oracle Java SE - Serializable</a> </li>
  <li> <a href="https://docs.oracle.com/en/java/javase/20/docs/api/java.base/java/io/ObjectOutputStream.html">Oracle Java SE - ObjectOutputStream</a>
  </li>
</ul>