<h2>Why is this an issue?</h2>
<p>Because <code>Object</code> implements <code>hashCode</code>, any Java class can be put into a hash structure. However, classes that define
<code>equals(Object)</code> but not <code>hashCode()</code> aren’t truly hash-able because instances that are equivalent according to the
<code>equals</code> method can return different hashes.</p>
<h3>Noncompliant code example</h3>

```java
public class Student {  // no hashCode() method; not hash-able
  // ...

  public boolean equals(Object o) {
    // ...
  }
}

public class School {
  private Map<Student, Integer> studentBody = // okay so far
          new HashTable<Student, Integer>(); // Noncompliant

  // ...
```
<h3>Compliant solution</h3>

```java
public class Student {  // has hashCode() method; hash-able
  // ...

  public boolean equals(Object o) {
    // ...
  }
  public int hashCode() {
    // ...
  }
}

public class School {
  private Map<Student, Integer> studentBody = new HashTable<Student, Integer>();

  // ...
```