<p>This rule is deprecated; use javasecurity:S6173 instead.</p>
<h2>Why is this an issue?</h2>
<p>Dynamically loaded classes could contain malicious code executed by a static class initializer. I.E. you wouldn’t even have to instantiate or
explicitly invoke methods on such classes to be vulnerable to an attack.</p>
<p>This rule raises an issue for each use of dynamic class loading.</p>
<h3>Noncompliant code example</h3>

```java
String className = System.getProperty("messageClassName");
Class clazz = Class.forName(className);  // Noncompliant
```
<h2>Resources</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A1_2017-Injection">Top 10 2017 Category A1 - Injection</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/470">CWE-470 - Use of Externally-Controlled Input to Select Classes or Code ('Unsafe
  Reflection')</a> </li>
</ul>