<h2>Why is this an issue?</h2>
<p>When the code under test in a unit test throws an exception, the test itself fails. Therefore, there is no need to surround the tested code with a
<code>try</code>-<code>catch</code> structure to detect failure. Instead, you can simply move the exception type to the method signature.</p>
<p>This rule raises an issue when there is a fail assertion inside a <code>catch</code> block.</p>
<p>Supported frameworks:</p>
<ul>
  <li> JUnit3 </li>
  <li> JUnit4 </li>
  <li> JUnit5 </li>
  <li> Fest assert </li>
  <li> AssertJ </li>
</ul>
<h3>Noncompliant code example</h3>

```java
@Test
public void testMethod() {
  try {
            // Some code
  } catch (MyException e) {
    Assert.fail(e.getMessage());  // Noncompliant
  }
}
```
<h3>Compliant solution</h3>

```java
@Test
public void testMethod() throws MyException {
    // Some code
}
```