<h2>Why is this an issue?</h2>
<p><code>@ComponentScan</code> is used to determine which Spring Beans are available in the application context. The packages to scan can be
configured thanks to the <code>basePackageClasses</code> or <code>basePackages</code> (or its alias <code>value</code>) parameters. If neither
parameter is configured, <code>@ComponentScan</code> will consider only the package of the class annotated with it. When <code>@ComponentScan</code>
is used on a class belonging to the default package, the entire classpath will be scanned.</p>
<p>This will slow-down the start-up of the application and it is likely the application will fail to start with an
<code>BeanDefinitionStoreException</code> because you ended up scanning the Spring Framework package itself.</p>
<p>This rule raises an issue when:</p>
<ul>
  <li> <code>@ComponentScan</code>, <code>@SpringBootApplication</code> and <code>@ServletComponentScan</code> are used on a class belonging to the
  default package </li>
  <li> <code>@ComponentScan</code> is explicitly configured with the default package </li>
</ul>
<h3>Noncompliant code example</h3>

```java
import org.springframework.boot.SpringApplication;

@SpringBootApplication // Noncompliant; RootBootApp is declared in the default package
public class RootBootApp {
...
}
```

```java
@ComponentScan("")
public class Application {
...
}
```
<h3>Compliant solution</h3>

```java
package hello;

import org.springframework.boot.SpringApplication;

@SpringBootApplication // Compliant; RootBootApp belongs to the "hello" package
public class RootBootApp {
...
}
```