<h2>Why is this an issue?</h2>
<p><code>Bean Validation</code> as per defined by JSR 380 can be triggered programmatically or also executed by the <code>Bean Validation</code>
providers. However something should tell the <code>Bean Validation</code> provider that a variable must be validated otherwise no validation will
happen. This can be achieved by annotating a variable with <code>javax.validation.Valid</code> and unfortunally it’s easy to forget to add this
annotation on complex Beans.</p>
<p>Not annotating a variable with <code>@Valid</code> means <code>Bean Validation</code> will not be triggered for this variable, but readers may
overlook this omission and assume the variable will be validated.</p>
<p>This rule will run by default on all <code>Class</code>'es and therefore can generate a lot of noise. This rule should be restricted to run only on
certain layers. For this reason, the "Restrict Scope of Coding Rules" feature should be used to check for missing <code>@Valid</code> annotations only
on some packages of the application.</p>
<h3>Noncompliant code example</h3>

```java
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class User {
  @NotNull
  private String name;
}

public class Group {
  @NotNull
  private List<User> users; // Noncompliant; User instances are not validated
}

public class MyService {
  public void login(User user) { // Noncompliant; parameter "user" is not validated
  }
}
```
<h3>Compliant solution</h3>

```java
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class User {
  @NotNull
  private String name;
}

public class Group {
  @Valid
  @NotNull
  private List<User> users; // Compliant; User instances are validated

  @NotNull
  // preferred style as of Bean Validation 2.0
  private List<@Valid User> users2; // Compliant; User instances are validated
}

public class MyService {
  public void login(@Valid User user) { // Compliant
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://beanvalidation.org/2.0/spec/">Bean Validation 2.0 (JSR 380)</a> </li>
</ul>