<h2>Why is this an issue?</h2>
<p>Duplicated string literals make the process of refactoring complex and error-prone, as any change would need to be propagated on all
occurrences.</p>
<h3>Exceptions</h3>
<p>To prevent generating some false-positives, literals having less than 10 characters are excluded as well as literals matching <code>/^\w*$/</code>.
String literals inside import/export statements and JSX attributes are also ignored. The same goes for statement-like string literals, e.g. <code>'use
strict';</code>.</p>
<h2>How to fix it</h2>
<p>Use constants to replace the duplicated string literals. Constants can be referenced from many places, but only need to be updated in a single
place.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<p>With the default threshold of 3:</p>

```js
function run() {
    prepare("action_to_launch");  // Noncompliant - "action_to_launch" is duplicated 3 times
    execute("action_to_launch");
    release("action_to_launch");
}

function printInQuotes(a, b) {
  console.log("'" + a + "'" + b + "'");               // Compliant - literal "'" has less than 10 characters and is excluded
}
```
<h4>Compliant solution</h4>

```js
var ACTION_1 = "action_to_launch";

function run() {
  prepare(ACTION_1);                               // Compliant
  execute(ACTION_1);
  release(ACTION_1);
}
```