<h2>Why is this an issue?</h2>
<p>In JavaScript, the <code>super</code> keyword is used to call the constructor and methods of an object’s parent class, and to access its
properties.</p>
<p>The expression <code>super(...args)</code> is used to call the parent’s constructor. It must be used carefully and correctly to avoid errors.</p>

```js
class Dog extends Animal {
  constructor(name) {
    super();
    this.name = name;
    super(); // Noncompliant: constructor is called twice.
    super.doSomething();
  }
}
```
<p>Follow these instructions when invoking the parent’s constructor:</p>
<ul>
  <li> <code>super()</code> cannot be invoked in the constructor of a non-derived class. </li>
  <li> <code>super()</code> must be invoked in the constructor of a derived class. </li>
  <li> <code>super()</code> must be invoked before the <code>this</code> and <code>super</code> keywords can be used. </li>
  <li> <code>super()</code> must be invoked with the same number of arguments as the base class' constructor. </li>
  <li> <code>super()</code> can only be invoked in a constructor - not in any other method. </li>
  <li> <code>super()</code> cannot be invoked multiple times in the same constructor. </li>
</ul>

```js
class Dog extends Animal {
  constructor(name) {
    super();
    this.name = name;
    super.doSomething();
  }
}
```
<p>Some issues are not raised if the base class is not defined in the same file as the current class. This is a known limitation of this rule.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/super"><code>super</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes">Classes</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Inheritance_and_the_prototype_chain">Inheritance and the
  prototype chain</a> </li>
</ul>