<h2>Why is this an issue?</h2>
<p>If you have an iterable, such as an array, set, or list, your best option for looping through its values is the <code>for of</code> syntax. Use
<code>for in</code> and you’ll iterate the properties, rather than the values.</p>
<h3>Noncompliant code example</h3>

```js
const arr = [4, 3, 2, 1];

for (let value in arr) {  // Noncompliant
  console.log(value);  // logs 0, 1, 2, 3
}
```
<h3>Compliant solution</h3>

```js
const arr = [4, 3, 2, 1];

for (let value of arr) {
  console.log(value);
}
```