<h2>Why is this an issue?</h2>
<p>Anchors, represented by the <code>a</code> tag in HTML, usually contain a hyperlink that users can click to navigate to different sections of a
website or different websites altogether.</p>
<p>However, when anchors do not have content or when the content is hidden from screen readers using the <code>aria-hidden</code> property, it creates
a significant accessibility issue. If an anchor’s content is hidden or non-existent, visually impaired users may not be able to understand the purpose
of the anchor or navigate the website effectively.</p>
<p>This rule checks that anchors do not use the <code>aria-hidden</code> property and have content provided either between the tags or as
<code>aria-label</code> or <code>title</code> property.</p>
<h2>How to fix it</h2>
<p>Ensure that anchors either have content or an <code>aria-label</code> or <code>title</code> attribute, and they should not use the
<code>aria-hidden</code> property.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
<a aria-hidden>link to my site</a>
```
<h4>Compliant solution</h4>

```js
<a>link to my site</a>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a"><code>&lt;a&gt;</code>: The Anchor element</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-hidden"><code>aria-hidden</code>
  attribute</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> W3C - <a href="https://www.w3.org/WAI/WCAG21/Understanding/link-purpose-in-context">Link purpose</a> </li>
</ul>