<h2>Why is this an issue?</h2>
<p>When a module imports itself it has no effect. This means that the import statement does nothing useful and serves no purpose. This can happen
during refactoring or when a developer mistakenly imports the module itself.</p>
<p>To fix the problem remove the self-import statement.</p>

```js
// file: foo.js
import foo from './foo'; // Noncompliant

const foo = require('./foo'); // Noncompliant
```

```js
// file: index.js
import index from '.'; // Noncompliant

const index = require('.'); // Noncompliant
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Modules">Modules</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/import">import</a> </li>
  <li> Node.js docs - <a href="https://nodejs.org/api/modules.html#requireid">Node.js require</a> </li>
</ul>