<h2>Why is this an issue?</h2>
<p><code>continue</code> is an unstructured control flow statement. It makes code less testable, less readable and less maintainable. Structured
control flow statements such as <code>if</code> should be used instead.</p>
<h3>Noncompliant code example</h3>

```js
  for (i = 0; i < 10; i++) {
    if (i == 5) {
      continue;  /* Noncompliant */
    }
    alert("i = " + i);
  }
```
<h3>Compliant solution</h3>

```js
  for (i = 0; i < 10; i++) {
    if (i != 5) {  /* Compliant */
      alert("i = " + i);
    }
  }
```