<h2>Why is this an issue?</h2>
<p>Nested <code>when</code> structures are difficult to understand because you can easily confuse the cases of an inner <code>when</code> as belonging
to an outer statement. Therefore nested <code>when</code> statements should be avoided.</p>
<p>Specifically, you should structure your code to avoid the need for nested <code>when</code> statements, but if you cannot, then consider moving the
inner <code>when</code> to another function.</p>
<h3>Noncompliant code example</h3>

```kotlin
fun foo(n: Int, m: Int) {
  when (n) {
    0 ->
      when (m) {  // Noncompliant; nested when
        // ...
      }
    1 -> print("1")
    else -> print("2")
  }
}
```
<h3>Compliant solution</h3>

```kotlin
fun foo(n: Int, m: Int) {
  when (n) {
    0 -> bar(m)
    1 -> print("1")
    else -> print("2")
  }
}

fun bar(m: Int){
  when(m) {
    // ...
  }
}
```