<h2>Why is this an issue?</h2>
<p><code>java.util.concurrent.ScheduledThreadPoolExecutor</code>'s pool is sized with <code>corePoolSize</code>, so setting <code>corePoolSize</code>
to zero means the executor will have no threads and run nothing.</p>
<p>This rule detects instances where <code>corePoolSize</code> is set to zero, via either its setter or the object constructor.</p>
<h3>Noncompliant code example</h3>

```kotlin
fun do() {

    val stpe1 = ScheduledThreadPoolExecutor(0) // Noncompliant

    val stpe2 = ScheduledThreadPoolExecutor(POOL_SIZE)
    stpe2.corePoolSize = 0 // Noncompliant

    ...
```