<h2>Why is this an issue?</h2>
<p>The <code>&lt;?php</code> tag is used to explicitly mark the start of PHP code in a file. It is considered the recommended and portable way to open
PHP blocks. On the other hand, the <code>&lt;?=</code> tag is a shorthand for <code>&lt;?php</code> echo and is specifically used to output variables
or expressions directly without using the echo statement. Not using these tags can make the code less readable and harder to maintain, as it deviates
from the standard conventions followed by most PHP developers.</p>
<h3>Noncompliant code example</h3>

```php
<?
$foo = 1;
?>
```
<h3>Compliant solution</h3>

```php
<?php
$foo = 1;
?>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.php.net/manual/en/language.basic-syntax.phptags.php">PHP Manual - PHP tags</a> </li>
</ul>