<h2>Why is this an issue?</h2>
<p>Creating a new <code>Exception</code> without actually throwing it is useless and is probably due to a mistake.</p>
<h3>Noncompliant code example</h3>

```php
if ($x < 0)
  new Exception('$x must be nonnegative');
```
<h3>Compliant solution</h3>

```php
if ($x < 0)
  throw new Exception('$x must be nonnegative');
```