<h2>Why is this an issue?</h2>
<p>PHPUnit provides helper functions and annotations to verify that a given block of code throws an exception and to assert different properties of
that exception. The provided helper functions are:</p>
<ul>
  <li> <code>expectException()</code> </li>
  <li> <code>expectExceptionCode()</code> </li>
  <li> <code>expectExceptionMessage()</code> </li>
  <li> <code>expectExceptionMessageRegExp()</code> </li>
</ul>
<p>This check raises an issue when the throw of an exception is verified using a <em>try-catch</em> approach instead of relying on the provided helper
functions.</p>
<h3>Noncompliant code example</h3>

```php
public function testA()
{
    try {
        doSomething();
        $this->fail("Assertion should have been thrown");
    } catch (MyException $e) {
        assertEquals("Exception message", $e->getMessage());
    }
}
```
<h3>Compliant solution</h3>

```php
public function testB()
{
    $this->expectException(MyException::class);
    $this->expectExceptionMessage("Exception message");

    doSomething();
}
```
<h2>Resources</h2>
<p>thePHP.cc: <a href="https://thephp.cc/articles/questioning-phpunit-best-practices">Questioning PHPUnit Best Practice</a></p>