<h2>Why is this an issue?</h2>
<p>Multiple spaces in a regular expression can make it hard to tell how many spaces should be matched. It’s more readable to use only one space and
then indicate with a quantifier how many spaces are expected.</p>
<h3>Noncompliant code example</h3>

```php
"/Hello,   world!/"
```
<h3>Compliant solution</h3>

```php
"/Hello, {3}world!/"
```
<h3>Exceptions</h3>
<p>If the extended modifier is set, whitespaces are ignored. In this case no issue should be triggered, because the whitespaces may be intended to
improve readability.</p>