<h2>Why is this an issue?</h2>
<p>A common code smell that can hinder the clarity of source code is making assignments within sub-expressions. This practice involves assigning a
value to a variable inside a larger expression, such as within a loop or a conditional statement.</p>
<p>This practice essentially gives a side-effect to a larger expression, thus making it less readable. This often leads to confusion and potential
errors.</p>
<p>Moreover, using chained assignments in declarations is also dangerous because one may accidentally create global variables. Consider the following
code snippet: <code>let x = y = 1;</code>. If <code>y</code> is not declared, it will be hoisted as global.</p>
<h3>Exceptions</h3>
<p>The rule does not raise issues for the following patterns:</p>
<ul>
  <li> chained assignments: <code>a = b = c = 0;</code> </li>
  <li> relational assignments: <code>(a = 0) != b</code> </li>
  <li> sequential assignments: <code>a = 0, b = 1, c = 2</code> </li>
  <li> assignments in lambda body: <code>() =&gt; a = 0</code> </li>
  <li> conditional assignment idiom: <code>a || (a = 0)</code> </li>
  <li> assignments in (do-)while conditions: <code>while (a = 0);</code> </li>
</ul>
<h2>How to fix it</h2>
<p>Making assignments within sub-expressions can hinder the clarity of source code.</p>
<p>This practice essentially gives a side-effect to a larger expression, thus making it less readable. This often leads to confusion and potential
errors.</p>
<p>Extracting assignments into separate statements is encouraged to keep the code clear and straightforward.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
if (val = value() && check()) { // Noncompliant
  // ...
}
```
<h4>Compliant solution</h4>

```ts
val = value();
if (val && check()) {
  // ...
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/481">CWE-481 - Assigning instead of Comparing</a> </li>
</ul>