<h2>Why is this an issue?</h2>
<p>A typical code smell known as unused function parameters refers to parameters declared in a function but not used anywhere within the function’s
body. While this might seem harmless at first glance, it can lead to confusion and potential errors in your code. Disregarding the values passed to
such parameters, the function’s behavior will be the same, but the programmer’s intention won’t be clearly expressed anymore. Therefore, removing
function parameters that are not being utilized is considered best practice.</p>
<h3>Exceptions</h3>
<p>When <code>arguments</code> is used in the function body, no parameter is reported as unused.</p>

```ts
function doSomething(a, b, c) {
  compute(arguments);
}
```
<p>The rule also ignores all parameters with names starting with an underscore (<code>_</code>). This practice is often used to indicate that some
parameter is intentionally unused. This practice is frequently seen in the TypeScript compiler, for example.</p>

```ts
function doSomething(_a, b) {
  return compute(b);
}
```
<h2>How to fix it</h2>
<p>Having unused function parameters in your code can lead to confusion and misunderstanding of a developer’s intention. They reduce code readability
and introduce the potential for errors. To avoid these problems, developers should remove unused parameters from function declarations.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function doSomething(a, b) { // "a" is unused
  return compute(b);
}
```
<h4>Compliant solution</h4>

```ts
function doSomething(b) {
  return compute(b);
}
```
<p>or</p>

```ts
function doSomething(_a, b) {
  return compute(b);
}
```