<h2>Why is this an issue?</h2>
<p>By convention, constructor function names should start with an upper case letter as a reminder that they should be called with the <code>new</code>
keyword.</p>
<p>A function is considered to be a constructor when it sets all of its arguments as object properties, and returns no value.</p>
<h3>Noncompliant code example</h3>

```ts
function person (firstName, middleInitial, lastName) {  // Noncompliant
  this.firstName = firstName;
  this.middleInitial = middleInitial;
  this.lastName = lastName;
}
```
<h3>Compliant solution</h3>

```ts
function Person (firstName, middleInitial, lastName) {
  this.firstName = firstName;
  this.middleInitial = middleInitial;
  this.lastName = lastName;
}
```