<h2>Why is this an issue?</h2>
<p>Variables declared with <code>var</code> are function-scoped, meaning they are accessible within the entire function in which they are defined. If
a variable is declared using <code>var</code> outside of any function, it becomes a global variable and is accessible throughout the entire JavaScript
program.</p>
<p><code>let</code> and <code>const</code> were introduced in ECMAScript 6 (ES6) as a block-scoped alternative to <code>var</code>. Variables declared
with <code>let</code> have block scope, meaning they are limited to the block of code in which they are defined. A block is typically delimited by
curly braces <code>{}</code>.</p>
<p>Variables declared with <code>const</code> are also block-scoped, similar to <code>let</code>. However, <code>const</code> variables are immutable,
meaning their value cannot be changed after assignment. This applies to the binding between the variable name and its value, but it does not mean the
value itself is immutable if it is an object or an array.</p>
<p>A variable declared with <code>let</code> or <code>const</code> is said to be in a "temporal dead zone", meaning the period between entering a
scope and declaring a <code>let</code> or <code>const</code> variable. During this phase, accessing the variable results in a
<code>ReferenceError</code>. This helps catch potential errors and encourages proper variable declaration.</p>
<p>Unlike <code>let</code> and <code>const</code>, variables declared with <code>var</code> are subject to "hoisting", which means that they are moved
to the top of their scope during the compilation phase, even if the actual declaration is placed lower in the code.</p>
<p>Hoisting can sometimes lead to unexpected behavior. For example, variables declared with <code>var</code> are accessible before they are declared,
although they will have the value <code>undefined</code> until the declaration is reached.</p>
<p>The distinction between the variable types created by <code>var</code> and by <code>let</code> is significant, and a switch to <code>let</code>
will help alleviate many of the variable scope issues which have caused confusion in the past.</p>
<p>Because these new keywords create more precise variable types, they are preferred in environments that support ECMAScript 2015. However, some
refactoring may be required by the switch from <code>var</code> to <code>let</code>, and you should be aware that they raise <code>SyntaxError</code>s
in pre-ECMAScript 2015 environments.</p>
<p>This rule raises an issue when <code>var</code> is used instead of <code>const</code> or <code>let</code>.</p>

```ts
var color = "blue"; // Noncompliant
var size = 4;       // Noncompliant
```
<p>You should declare your variables with either <code>const</code> or <code>let</code> depending on whether you are going to modify them
afterwards.</p>

```ts
const color = "blue";
let size = 4;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/var">var</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/let">let</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/const">const</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Scope">Scope</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Hoisting">Hoisting</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/let#temporal_dead_zone_tdz">Temporal dead
  zone (TDZ)</a> </li>
</ul>