<h2>Why is this an issue?</h2>
<p>User-defined JSX components should use Pascal case because it is a widely accepted convention in the React community. Using Pascal case for
component names helps to distinguish them from HTML elements and built-in React components, which are typically written in lowercase. It also improves
code readability and makes it easier to differentiate between components and regular HTML tags.</p>
<p>Additionally, adhering to this convention ensures consistency and makes it easier for other developers to understand and work with your code. It is
considered a best practice in React development and is recommended by the official React documentation.</p>

```ts
<MY_COMPONENT />
```
<p>You should rename your component according to Pascal case and all its usages as JSX elements.</p>

```ts
<MyComponent />
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/learn#components">Creating and nesting components</a> </li>
</ul>