<h2>Why is this an issue?</h2>
<p>Interactive DOM elements are elements that users can interact with. These include buttons, links, form inputs, and other elements that can be
clicked, focused, or otherwise manipulated by the user. ARIA roles, on the other hand, are used to improve accessibility by providing additional
semantic information about an element’s purpose and behavior. ARIA roles can be divided into two categories: interactive roles and non-interactive
roles.</p>
<p>Interactive ARIA roles are used for elements that a user can interact with, such as buttons or sliders. Non-interactive ARIA roles are used for
elements that are not meant to be interacted with, such as content containers or landmarks. Examples of non-interactive ARIA roles include
<code>article</code>, <code>banner</code>, <code>complementary</code>, <code>contentinfo</code>, <code>definition</code>, <code>directory</code>,
<code>document</code>, <code>feed</code>, <code>figure</code>, <code>group</code>, <code>heading</code>, <code>img</code>, <code>list</code>,
<code>listitem</code>, <code>math</code>, <code>none</code>, <code>note</code>, <code>presentation</code>, <code>region</code>,
<code>separator</code>, <code>status</code>, <code>term</code>, and <code>tooltip</code>.</p>
<p>Interactive DOM elements should not have non-interactive ARIA roles because it can confuse assistive technologies and their users. For example, if
a button (an interactive element) is given a non-interactive ARIA role like <code>article</code>, it can mislead users into thinking that the button
is just a piece of content, not something they can interact with. This can lead to a poor user experience, especially for users who rely on assistive
technologies to navigate the web.</p>
<p>Therefore, it’s important to ensure that interactive DOM elements are not given non-interactive ARIA roles.</p>
<h2>How to fix it</h2>
<p>Ensure that interactive DOM elements are not given non-interactive ARIA roles.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function myButton() {
    return <button role="article">Click me!</button>; // Noncompliant; "button" is interactive, but "article" isn't
}
```
<h4>Compliant solution</h4>

```ts
function myButton() {
    return <button role="button">Click me!</button>;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> WCAG - <a href="https://www.w3.org/WAI/WCAG21/Understanding/name-role-value">Name, Role, Value</a> </li>
  <li> WCAG - <a href="https://www.w3.org/TR/wai-aria-1.1/#usage_intro">WAI-ARIA Roles</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles">WAI-ARIA Roles</a> </li>
</ul>